import {BlurPublicImage} from "@/app/components/BlurImage";
import {generateMetadata} from "@/app/helpers/generateMetadata";

export const metadata = generateMetadata({
    title: "Careers: Drive Innovation in Chemical Process Solutions",
    description: "Shape your future with TranTech Careers. Join our team advancing planning, investment & process solutions in chemical, petrochemical and polymer sectors.",
    keywords: "chemical process careers, advanced engineering opportunities, petrochemical innovation roles, polymer strategy vacancies, chemical engineering jobs"
})


const Page = () => {
    return (<div className="container-fluid page-content">
        <div className="page-title">
            <div className="container">
                <h2>Careers at TranTech</h2>

                <p className="color-secondary">Shape your career with our team</p>
                <p>Join our dynamic team of experts and grow your career alongside chemical process industry
                    veterans</p>

                <br/>
            </div>
        </div>

        <div id="company" className="content">


            <div className="container" style={{marginTop: "4rem"}}>
                <div className="row">
                    <div className="col-5 story-content">

                        <p> At TranTech Consultants, we believe that our success is defined by the talent, passion,
                            and
                            creativity of our people. Our team is at the forefront of technological innovation and
                            strategic market intelligence, tackling complex challenges in the chemical,
                            petrochemical,
                            and sustainability sectors every day. If you’re driven by a desire to push the
                            boundaries of
                            engineering, data analytics, and industry expertise, you’ll find a place where your
                            ideas
                            matter and your contributions are valued.
                            <br/>
                            <br/>
                            We offer a collaborative, dynamic work environment that fosters professional growth and
                            continuous learning. Employees at TranTech Consultants enjoy the opportunity to work on
                            transformative projects that are shaping the chemical process industry, while being
                            supported by leaders who are committed to your success. Our diverse teams bring together
                            expertise in engineering, market intelligence, sustainable practices, and strategic
                            planning, creating a rich environment of innovative problem-solving and forward-thinking
                            approaches.
                            <br/>
                            <br/>
                            We believe that every individual has the potential to make a meaningful impact. Whether
                            you’re a seasoned professional, a recent graduate, or still a student, TranTech offers a
                            platform where you can grow, innovate, and make impact.
                        </p>

                    </div>
                    <div style={{marginLeft: "60px"}} className="col-5 story-image">
                        <BlurPublicImage style={{position: "relative", top: 0, width: "100%", height: "auto"}}
                                         src={"/img/webp/careers/Have skills.webp"} alt={"Have skills"} width={1263}
                                         height={813}/>
                    </div>
                </div>
            </div>
            <div className="content padding-0 d-flex" style={{marginTop: "4rem"}}>
                <BlurPublicImage style={{maxWidth: "100%", height: "auto"}}
                                 src={"/img/webp/careers/Careers Image.webp"} alt={"Have skills"} width={3246}
                                 height={2044}/>

            </div>
            <div className="inner-content">

                <div className="column careers company-philosophy">


                    <div className="our">
                        <h3>Students and graduates</h3>
                        <p className="subtitle color-secondary">Start your journey with us</p>
                        <p> At TranTech, you’ll find fresh challenges, new ways of thinking, and exciting
                            opportunities
                            to kickstart your career. With specialist training programs, mentorship schemes, and a
                            supportive environment, we provide the tools you need to grow, progress, and discover
                            the
                            role you’ve been waiting for.
                            <br/>
                            <br/>
                            Whether you’re passionate about chemical engineering, financial analysis, data-driven
                            solutions, or software development, TranTech is the place to turn your ideas into
                            reality.
                        </p>
                    </div>

                    <div className="our">
                        <h3>Professionals</h3>
                        <p className="subtitle color-secondary">Grow and thrive with us</p>
                        <p>
                            For experienced professionals, TranTech offers impressive learning opportunities,
                            flexible
                            working policies, and the chance to shape your career on your terms. Whether you’re
                            looking
                            to lead innovative projects, develop new skills, or take on new challenges, we’ll be
                            with
                            you every step of the way.
                            <br/>
                            <br/>
                            Join a team that values your expertise and empowers you to make a difference. At
                            TranTech,
                            your career is not just a job—it’s a journey of growth and impact.
                        </p>
                    </div>

                    <div className="our">
                        <h3>Contingent workers</h3>
                        <p className="subtitle color-secondary">Be part of a global team</p>
                        <p> TranTech is a truly global company, and our values and behaviors are the cornerstones of
                            everything we do. Our contingent workforce plays a vital role in driving our success,
                            bringing highly specialized skills and diverse perspectives to the table.
                            <br/>
                            <br/>
                            If you’re looking to contribute to an expert, dynamic, and forward-thinking
                            organization, we
                            welcome you to join our team. Together, we can achieve great things.</p>
                        <br/>
                    </div>

                </div>
            </div>

            <div className="inner-content container">
                <div style={{padding:"2rem 0"}} className="page-title">
                    <h2 style={{fontSize: "3rem"}}>Take the initiative</h2>
                </div>
                <div className="row">
                    <div className="col-5 story-content">

                        <p>
                            Are you passion for data-driven solutions and digital transformation?
                            Do you see yourself working for a fast-growing company that’s driving innovation and
                            making
                            a real impact in the Chemical Process Industries? If so, <span
                            className="color-primary bold"> we want to hear from you!</span>
                            <br/>
                            <br/>
                            Even if we don’t currently have an opening that perfectly matches your skills and
                            expertise, don’t let that stop you. Take the initiative and send us an application. Tell
                            us about yourself, your desired position, and why you’re the perfect fit for our team.
                            <br/>
                            <br/>
                            At TranTech, <span
                            className="bold">we’re always on the lookout for talented individuals</span> who share our
                            vision
                            and values. If you’re ready to contribute to groundbreaking solutions, your next
                            opportunity could be just one application away.
                        </p>
                    </div>
                    <div className="col-5 story-image">
                        <BlurPublicImage
                            style={{position: "relative", top: 0, width: "100%", padding: "0 10%", height: "auto"}}
                            src={"/img/webp/careers/Take the initiative.svg"} alt={"Take the initiative"}
                            width={1263}
                            height={813}/>
                    </div>
                </div>
            </div>
            <div className="blue-section">
                <div className="container">
                    <h2>Why join TranTech?</h2>
                    <br/>
                    <p className="color-secondary">More than a job – a career with purpose and impact
                    </p>
                    <p>Enjoy mentorship from industry leaders while working on projects that redefine market
                        standards</p>

                </div>
            </div>
            <div className="inner-content container">

                <p>
                    At TranTech Consultants, we don't just offer jobs—we build careers. Our dynamic, forward-thinking
                    environment empowers you to play a pivotal role in shaping the future of the chemical and process
                    industries. When you join TranTech, you're not only becoming part of a prestigious legacy spanning
                    over 40 years but also stepping into a culture that values innovation, sustainability, and
                    continuous professional growth.<br/>
                    Join TranTech Consultants and experience a workplace where your ideas are valued, your expertise is
                    honed, and your ambition is rewarded.
                </p>
<br/>
<br/>
                <div id="why-join-trantech" className="why-join">
                    <div className="reason">
                        <div className="reason-img">
                            <BlurPublicImage src={"/img/svg/careers/40 year experience.png"}
                                             alt={"40+ year experience"}
                                             width={141}
                                             height={116}/>
                        </div>
                        <p style={{whiteSpace: "nowrap"}} className="color-primary bold">40+ Years of expertise</p>
                        <p className="desc">Be part of a company with a proven track record and a vision for the future</p>
                    </div>

                    <div className="reason">
                        <div className="reason-img">
                            <BlurPublicImage src={"/img/svg/careers/ennovative environment.svg"}
                                             alt={"Innovative Environment"}
                                             width={525}
                                             height={432}/>
                        </div>
                        <p style={{whiteSpace: "nowrap"}} className="color-primary bold">Innovative environment</p>
                        <p className="desc">Work with cutting-edge tools and technologies that are shaping the chemical process industry</p>
                    </div>

                    <div className="reason">
                        <div className="reason-img">
                            <BlurPublicImage style={{maxWidth: "120px", maxHeight: "100%"}}
                                             src={"/img/svg/careers/Growth Oppurtunity.svg"}
                                             alt={"Growth Opportunities"}
                                             width={525}
                                             height={432}/>
                        </div>
                        <p style={{whiteSpace: "nowrap"}} className="color-primary bold">Flexible Work Culture</p>
                        <p className="desc">Access training, mentorship, and career development tailored to your goals</p>
                    </div>

                    <div className="reason">
                        <div className="reason-img">
                            <BlurPublicImage src={"/img/svg/careers/Flexible Work Culture.svg"}
                                             alt={"Flexible Work Culture"}
                                             width={525}
                                             height={432}/>
                        </div>
                        <p style={{whiteSpace: "nowrap"}} className="color-primary bold">Growth opportunities</p>
                        <p className="desc">Enjoy a supportive and flexible work environment that values work-life balance.</p>


                    </div>
                </div>

                <div style={{padding: "2rem 0", marginTop: "50px", marginBottom: "10px"}} className="page-title">
                    <h2 style={{fontWeight: 400}}>Ready to take the next step?</h2>
                </div>
                <p>If you’re excited about the opportunity to grow your career with TranTech, we’d love to hear from
                    you. Send your resume to <a style={{textDecoration: "underline"}} className="color-primary"
                                                href="mailto:careers@trantechglobal.com">careers@trantechglobal.com</a>,
                    and let’s start a conversation.
                </p><br/>
                <p>Your career journey begins here. Join TranTech and make an impact that matters.</p>

            </div>


        </div>



    </div>)
}


export default Page;