// import {BlurPublicImage} from "@/app/components/BlurImage";
// import {BlurPublicImage} from "@/app/components/BlurImage";
import Link from "next/link";
import {BlurPublicImage} from "@/app/components/BlurImage";
import {categories} from "@/app/data/categories.json"

export const Footer = () => {
    let products = categories.filter(x => x.id === "products")
    let solutions = categories.filter(x => x.id === "solutions")

    if (products.length > 0) {
        products = products[0].sub_category;
    }
    if (solutions.length > 0) {
        solutions = solutions[0].sub_category;
    }

    return (<div className="" id="footer">
            <div className="top">
                <div className="container" style={{width:"75vw"}}>
                    <div className="column" style={{marginBottom: "30px"}}>
                        <BlurPublicImage src="/img/svg/TranTech Logo.svg" alt="Trantech logo" width={230} height={80}/>
                    </div>
                    <div className="row  footer-columns">
                        <div style={{width:"27%"}} className="col-3">
                            <p>
                                697 Bobwhite Lane, Huntingdon Valley,
                                Philadelphia, PA 19006, US
                            </p>
                            <br/>
                            <p>info@trantechglobal.com</p>

                            <br/>
                            <ul>
                                <li><a href="/company/privacy-policy">Privacy policy</a></li>
                                <li><a href="/company/cookie-settings">Cookie settings</a></li>
                                <li><a href="/company/terms-and-conditions">Terms and conditions</a></li>
                                <li><a href="/company/license-information">License information</a></li>
                                <li><a href="/company/user-documentation">User documentation</a></li>
                            </ul>
                        </div>
                        <div style={{width:"27%"}} className="col-3">
                            <p className="footer-title">Our Business</p>
                            <ul>
                                <li><a>Products</a>
                                    <ul>

                                        {products.map((x, index) => <li key={x.id + index}><a href={x.slug}>{x.name}</a>
                                        </li>)}
                                    </ul>
                                </li>
                                <li><a>Solutions</a>
                                    <ul>
                                        {solutions.map((x, index) => <li key={x.id + index}><a
                                            href={x.slug}>{x.name}</a></li>)}
                                    </ul>
                                </li>
                            </ul>
                        </div>
                        <div style={{width:"27%"}} className="col-2">
                            <p className="footer-title">
                                Industries
                            </p>
                             <li><a>Chemicals and petrochemicals</a>
                                <ul>
                                    <li><a href="/solutions/industries#commodities">Commodities</a></li>
                                    <li><a href="/solutions/industries#intermediates">Intermediates</a></li>
                                    <li><a href="/solutions/industries#speciality-chemicals"> Speciality chemicals</a></li>
                                    <li><a href="/solutions/industries#polymers-and-resins"> Polymers and resins</a></li>
                                </ul>
                            </li>
                            <li><a>Sustainability solutions</a>
                                <ul>
                                    <li><a href="/solutions/industries#air-and-waste-treatment">Air and Waste Treatment</a></li>
                                    <li><a href="/solutions/industries#waste-to-product-strategies">Waste-to-Product Strategies</a></li>
                                    <li><a href="/solutions/industries#decarbonization-roadmaps">Decarbonization Roadmaps</a></li>
                                    <li><a href="/solutions/industries#hydrogen-economy-integration">Hydrogen Economy Integration</a></li>
                                    <li><a href="/solutions/industries#utilities-and-energy-management">Utilities and Energy Management</a></li>
                                </ul>
                            </li>
                        </div>
                        <div style={{width:"19%"}} className="col-2">
                            <p className="footer-title">Company</p>

                            <ul>
                                <li><a href="/company/about">Who we are?</a></li>
                                <li><a href="/careers">Careers</a></li>
                                <li><a href="/company/events">Events</a></li>
                                <li><a href="/company/research">Research</a></li>
                            </ul>
                            <br/>
                            <p className="footer-title">Support</p>
                            {/*<ContactUs_BTN className={"btn-link"}/>*/}
                            {/*<p><Link href={"https://wa.me/14752391846"}>*/}
                            {/*    <img src={"/img/svg/WhatsApp.webp"} width={18} style={{position: "relative", top: "3px"}}/>*/}
                            {/*    +1 (475) 239 1846*/}
                            {/*</Link></p>*/}
                            <p><Link href={"mailto:support@trantechglobal.com"}>support@trantechglobal.com</Link></p>
                            {/*<p><BlurPublicImage style={{position:"relative", top:"4px"}} src={"/img/svg/WhatsApp.webp"} alt={"whatsapp"} width={18} height={18}/>+1 (475) 239 1846</p>*/}
                            {/*<p><BookDemoCall_BTN className={"btn-link"}/>*/}
                            {/*</p>*/}
                            {/*<p><StayConnected_BTN className={"btn-link"}/></p>*/}
                        </div>
                    </div>

                </div>
            </div>
            <div className="bottom">
                <div className="container" style={{width: "75vw"}}>
                    <div className="row">
                        <p style={{textAlign: " center",width:"100%", padding: "12px 0 15px", color: "#fff"}}>Copyright (c)
                            1981-2025
                            TranTech Consultants, Inc., All rights reserved. All trademarks are the property of
                            their
                            respective owners.
                        </p>
                    </div>
                </div>
            </div>
        </div>

    )
}