import {categories} from "@/app/data/categories.json"
import {BlurPublicImage} from "@/app/components/BlurImage";
import Link from "next/link";

export const Header = () => {
    if (typeof window !== "undefined") {
        window.addEventListener("load", () => {
            let cats = document.getElementsByClassName("cat-list");
            console.log({ cats });
        });
    }

    return (
        <header>
            <div id="header" className="container-fluid">
                <div className="logo">
                    <a className="chemplan" style={{textDecoration: "none"}} href={"/"}>
                        <BlurPublicImage src="/img/svg/TranTech Logo1.svg" alt="Trantech logo" width={230} height={80}/>
                    </a>
                </div>
                <div className="menu">

                    <input
                        type="radio"
                        name="main-menu"
                        id="menu-toggle-none"
                        hidden
                        defaultChecked
                    />

                    <label htmlFor="menu-toggle-none" className="menu-overlay"></label>
                    <ul>
                        {categories.map((cat, idx) =>
                            <li className="cat-list" key={cat.id}>
                                <input
                                    type="radio"
                                    name="main-menu"
                                    id={`menu-toggle-${idx}`}
                                    hidden
                                />
                                <label htmlFor={`menu-toggle-${idx}`}>
                                    {cat.slug ? <a href={cat.slug}>{cat.name}</a> : <a>{cat.name}</a>}
                                </label>
                                {cat.sub_category && cat.sub_category.length > 0 && <>
                                    <label htmlFor="menu-toggle-none" className="close-submenu"> </label>
                                    <div className="submenu">
                                        <div className="row">
                                            <div className="col-4 submenu-list">
                                                <p className="submenu-list-title">TranTech Products</p>
                                                <ul>
                                                    {cat.sub_category.map((subCat, subIdx) =>
                                                        <li key={subCat.id} data-subcat-id={subCat.id}>
                                                            <a href={subCat.slug}>
                                                                <p className="title">{subCat.name}</p>
                                                                <p className="sub-desc">{subCat.short_desc1}</p>
                                                            </a>
                                                            <div className="desc" data-desc-id={subCat.id}>
                                                                <div className="top">
                                                                    <div>
                                                                        <h3>{subCat.name}</h3>
                                                                        <p className="sub-desc">{subCat.short_desc2}</p>
                                                                        <p className="sub-desc"
                                                                           style={{color: "#4d4d4d"}}>{subCat.full_desc}</p>
                                                                        {subCat.custom_btn1 && (
                                                                            <Link href={subCat.custom_btn_link1}
                                                                                className="btn-secondary">{subCat.custom_btn1}</Link>
                                                                        )}
                                                                        {subCat.custom_btn2 && (
                                                                            <Link href={subCat.custom_btn_link2}
                                                                                  className="btn-secondary">{subCat.custom_btn2}</Link>
                                                                        )}
                                                                        {subCat.custom_btn3 && (
                                                                            <Link href={subCat.custom_btn_link3}
                                                                                  className="btn-secondary">{subCat.custom_btn3}</Link>
                                                                        )}
                                                                    </div>
                                                                    <div className="top-image">
                                                                        {subCat.icon && <img
                                                                            src={subCat.icon || "https://placehold.co/150"}
                                                                            alt=""/>}
                                                                    </div>
                                                                </div>
                                                                <div className="featrue">
                                                                    <ul>
                                                                        {subCat.key_features && subCat.key_features.map((feature, idx) => {

                                                                            let desc = feature.desc.split("&&");

                                                                            return <li key={idx}>
                                                                                <div className="featrue-image">
                                                                                    <img
                                                                                        src={feature.icon || "http://placehold.co/50"}
                                                                                        alt=""/>
                                                                                </div>
                                                                                <div className="featrue-desc">
                                                                                    <p className="title"
                                                                                       style={desc.length > 1 ? {marginBottom: "10px"} : {}}>{feature.title}</p>
                                                                                    {desc.length < 2 &&
                                                                                        <p className="subtitle">{desc[0]}</p>}
                                                                                    {desc.length > 1 && desc.map(x => <p
                                                                                        style={{margin: "3px 0"}}
                                                                                        key={x}
                                                                                        className="subtitle">{x}</p>)}
                                                                                </div>
                                                                            </li>
                                                                        })}
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    )}
                                                </ul>
                                            </div>
                                            <div className="col-6 desc default-desc" id={"default-desc"}>
                                                {cat.sub_category[0] && (
                                                    <>
                                                        <div className="top">
                                                            <div>
                                                                <h3>{cat.sub_category[0].name}</h3>
                                                                <p className="sub-desc">{cat.sub_category[0].short_desc2}</p>
                                                                <p className="sub-desc"
                                                                   style={{color: "#4d4d4d"}}>{cat.sub_category[0].full_desc}</p>

                                                                {cat.sub_category[0].custom_btn1 && (
                                                                    <button
                                                                        className="btn-secondary">{cat.sub_category[0].custom_btn1}</button>
                                                                )}
                                                                {cat.sub_category[0].custom_btn2 && (
                                                                    <button
                                                                        className="btn-secondary">{cat.sub_category[0].custom_btn2}</button>
                                                                )}
                                                                {cat.sub_category[0].custom_btn3 && (
                                                                    <button
                                                                        className="btn-secondary">{cat.sub_category[0].custom_btn3}</button>
                                                                )}
                                                            </div>
                                                            <div className="top-image">
                                                                {cat.sub_category[0].icon && <img
                                                                    src={cat.sub_category[0].icon || "https://placehold.co/150"}
                                                                    alt=""/>}
                                                            </div>
                                                        </div>
                                                        <div className="featrue">
                                                            <ul>
                                                                {cat.sub_category[0].key_features && cat.sub_category[0].key_features.map((feature, idx) => (
                                                                    <li key={idx}>
                                                                        <div className="featrue-image">
                                                                            <img
                                                                                src={feature.icon || "http://placehold.co/50"}
                                                                                alt=""/>
                                                                        </div>
                                                                        <div className="featrue-desc">
                                                                            <p className="title">{feature.title}</p>
                                                                            <p className="subtitle">{feature.desc}</p>
                                                                        </div>
                                                                    </li>
                                                                ))}
                                                            </ul>
                                                        </div>
                                                    </>
                                                )}
                                            </div>
                                        </div>
                                    </div>
                                </>
                                }
                            </li>
                        )}
                    </ul>

                </div>
                <div className="logo" style={{textAlign:"end"}}>
                   <ul>
                       <li className="cat-list">
                           <label>
                               <a className="chemplan" style={{textDecoration: "none"}} href={"https://chemplan.biz"}>
                                   <BlurPublicImage src={"/img/svg/ChemPlan Logo.svg"} alt={"Providing technology licences"} width={110} height={100}/>
                                   <i style={{marginLeft:"10px",position:"relative",top:"3px"}} className="fa-regular fa-arrow-right"></i></a>
                           </label>
                       </li>
                   </ul>
                </div>
            </div>

        </header>
    )
}