"use client"
import {Swiper, SwiperSlide} from "swiper/react";
import {Autoplay, Navigation, Pagination} from "swiper/modules";
import 'swiper/css';
import 'swiper/css/pagination';

import Image from "next/image";


export const Carousel_Services = () => <div className="">
    <Swiper
        slidesPerView={1}

        spaceBetween={0}
        autoplay={{
            delay: 5000,
            disableOnInteraction: false,
        }}
        // breakpoints={{
        //     640: {
        //         slidesPerView: 1,
        //         spaceBetween: 20,
        //     },
        //     768: {
        //         slidesPerView: 1,
        //         spaceBetween: 40,
        //     },
        //     1024: {
        //         slidesPerView: 1,
        //         spaceBetween: 50,
        //     },
        // }}
        centeredSlides={false}
        pagination={{
            clickable: true,
        }}
        loop={true}
        modules={[Autoplay, Pagination, Navigation]}
        className="mySwiper services-carousel"
    >

        <SwiperSlide>
            <div className="slide">
                <div className="slide-image">
                    <Image src={"/img/webp/services-slider/slide-1.webp"} alt={"Concept study and strategic advisory"} width={4545} height={2727}/>
                </div>
                 <div className="slide-content">
                     <div className="slide-title">
                         <h3>Concept study and strategic advisory</h3>
                     </div>
                     <div className="slide-desc">
                        <p>
                            Our Concept Study and Strategic Advisory services lay the critical groundwork for every successful venture. We begin by thoroughly evaluating your project’s technical feasibility and market potential through extensive research and data analysis. Our expert team collaborates with your stakeholders to understand key challenges and opportunities, using state-of-the-art models and simulations to forecast performance. By scrutinizing risk factors, financial impacts, and emerging market trends, we provide you with tailored recommendations that clarify your strategic direction.
                        </p>
                     </div>
                     <div className="slide-buttons">
                         <a className="btn-secondary" href="/solutions/concept-study-strategic-advisory">Read more <i
                             className="fa-regular fa-arrow-right"></i></a>
                     </div>
                 </div>
            </div>
        </SwiperSlide>
        <SwiperSlide>
            <div className="slide slide-reverse">
                <div className="slide-image">
                    <Image src={"/img/webp/services-slider/slide-2.webp"} alt={"Engineering and design"} width={4545} height={2727}/>
                </div>
                <div className="slide-content">
                    <div className="slide-title">
                        <h3>Engineering and design</h3>
                    </div>
                    <div className="slide-desc">
                        <p>
                            Our Engineering and Design services transform innovative ideas into practical, high-performance solutions. We develop detailed process blueprints and system architectures, ensuring that each design meets both regulatory standards and operational excellence. Our engineers apply a holistic approach that considers every aspect of plant design—from layout and equipment selection to energy utilization and safety protocols. This relentless focus on precision and quality results in designs that are both cost-effective and future-proof, driving continuous improvement and operational excellence across your facilities.
                        </p>
                    </div>
                    <div className="slide-buttons">
                        <a className="btn-secondary" href="/solutions/engineering-design">Read more <i
                            className="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </SwiperSlide>
        <SwiperSlide>
            <div className="slide">
                <div className="slide-image">
                    <Image src={"/img/webp/services-slider/slide-3.webp"} alt={"Strategic planning"} width={4545} height={2727}/>
                </div>
                <div className="slide-content">
                    <div className="slide-title">
                        <h3>Strategic planning</h3>
                    </div>
                    <div className="slide-desc">
                        <p>
                            Strategic Planning is at the heart of our offering, enabling your organization to navigate complexities with agility and clarity. We take a forward-thinking approach by integrating deep market intelligence with rigorous technical analysis to develop robust, dynamic roadmaps. Our planning processes involve comprehensive evaluations of market fluctuations, technology advancements, and resource allocation, ensuring that you are prepared for both current challenges and future opportunities. We work closely with your leadership to formulate actionable strategies that balance short-term objectives with long-term growth, risk mitigation, and competitive positioning. This strategic foresight helps turn potential hurdles into stepping stones for success, ensuring that your organization remains resilient and agile.
                        </p>
                    </div>
                    <div className="slide-buttons">
                        <a className="btn-secondary" href="/solutions/strategic-planning">Read more <i
                            className="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </SwiperSlide>
        <SwiperSlide>
            <div className="slide slide-reverse">
                <div className="slide-image">
                    <Image src={"/img/webp/services-slider/slide-4.webp"} alt={"Market strategy"} width={4545} height={2727}/>
                </div>
                <div className="slide-content">
                    <div className="slide-title">
                        <h3>Market strategy</h3>
                    </div>
                    <div className="slide-desc">
                        <p>
                            Crafting a winning market strategy involves more than just analyzing trends—it requires a holistic understanding of competitive forces and consumer dynamics. With our Market Strategy services, we dive into market data, competitor profiles, and pricing dynamics to identify untapped opportunities and optimize your product portfolio. We leverage our extensive, integrated databases to provide real-time insights, allowing you to adjust strategy quickly in response to market shifts. Whether it’s refining your go-to-market approach or pinpointing niche segments, our team works with you to design a strategy that maximizes profitability and strengthens your market share. This systematic, data-driven approach ensures that every strategic decision is rooted in robust evidence, ultimately enabling you to outmaneuver competitors and lead with confidence.
                        </p>
                    </div>
                    <div className="slide-buttons">
                        <a className="btn-secondary" href="/solutions/market-strategy">Read more <i
                            className="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </SwiperSlide>
        <SwiperSlide>
            <div className="slide">
                <div className="slide-image">
                    <Image src={"/img/webp/services-slider/slide-5.webp"} alt={"Periodic reports"} width={4545} height={2727}/>
                </div>
                <div className="slide-content">
                    <div className="slide-title">
                        <h3>Periodic reports</h3>
                    </div>
                    <div className="slide-desc">
                        <p>
                            Staying informed in today’s fast-paced industry environment is essential, and our Periodic Reports provide the pulse on critical trends and emerging opportunities. Compiled by a team of seasoned experts, these reports offer comprehensive updates on market dynamics, technological innovations, regulatory changes, and competitor movements. We deliver in-depth analyses supported by data visualizations and trend forecasting to ensure that you have a clear picture of both current conditions and future projections. These regular insights not only support day-to-day decision-making but also serve as a strategic tool for long-term planning. By keeping you continually informed, our periodic reports enable you to anticipate changes, adapt to evolving market conditions, and maintain a competitive edge in a dynamic industry landscape.
                        </p>
                    </div>
                    <div className="slide-buttons">
                        <a className="btn-secondary" href="/solutions/periodic-reports">Read more <i
                            className="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </SwiperSlide>



    </Swiper>
</div>
