import {BlurPublicImage} from "@/app/components/BlurImage";
import {ClientLogos} from "@/app/clients/ClientLogos";
import {generateMetadata} from "@/app/helpers/generateMetadata";

export const metadata = generateMetadata({
    title: "Clients: Chemical Process Industries",
    description: "Discover leading chemical, petrochemical & polymer clients leveraging TranTech's advanced planning, investment, and engineering solutions for sustainable success.",
    keywords: "chemical industry partnerships, strategic planning testimonials, petrochemical ROI optimization, polymer process excellence, engineering innovation leadership"
})


const Page = () => {
    return (<div className="container-fluid page-content">
        <div className="page-title">
            <div className="container">
                <h2>Our clients worldwide</h2>
                <p className="color-secondary">The world’s leading chemical companies</p>
                <p>Our clients are industry leaders who trust us to deliver date-driven solutions and expert
                    insights</p>

                <br/>
            </div>
        </div>
        <div id="client" className="content" style={{padding: 0, margin: 0}}>
            <div className="container">
                <p style={{margin: "4rem 0"}}>

                    At TranTech Consultants, Inc., we are honored to work with some of the most respected names in the
                    Chemical Process
                    Industries. Our clients are industry leaders who trust us to deliver date-driven solutions, expert
                    insights, and
                    cutting-edge tools that drive their success. We proudly serve a diverse, global community of
                    industry
                    leaders
                    spanning the chemical, petrochemical, and process sectors. Our partners rely on our tailored
                    insights
                    and
                    cutting-edge solutions to drive operational excellence and sustainable growth.<br/>
                    Our worldwide network of clients benefits from our deep industry expertise, robust data analytics,
                    and
                    strategic planning capabilities. By real-time tracking over 9,000 plants and 8,000 processes across
                    the
                    globe, we deliver actionable intelligence that empowers organizations to excel in competitive
                    markets
                    and navigate complex regulatory landscapes.
                    <br/>
                    <br/>
                    We are honored to collaborate with a global roster of distinguished companies, helping them to
                    unlock
                    new opportunities and maintain their competitive edge.
                </p>

                <ClientLogos/>


                <div className="logos" style={{paddingTop: "30px", gap: 0}}>
                    <h3>Building Trust, Delivering Results</h3>
                    <p>Our partnerships are built on trust, collaboration, and a shared commitment to excellence.
                        Whether it’s through strategic planning, market research, or digital transformation, we are
                        dedicated to helping our clients achieve their goals and stay ahead in a competitive industry.
                    </p>
                </div>

            </div>

            <div id="why-industry-leaders-trust-trantech" className="page-title">
                <div className="container">
                    <h2>Why do industry leaders trust TranTech?</h2>
                    <p className="color-secondary">40+ Years of trusted partnerships</p>
                    <p>Decades of expertise, cutting-edge innovation, and unmatched reliability is the foundation of
                        trust for global industry leaders
                    </p>

                    <br/>
                </div>
            </div>

            <div id="why-choose" className="inner-content container">


                <div className="why-choose">
                    <div className="item">
                        <div className="item-image"><img src="/img/products/ultimated-user.png" alt="ultimated-user"/>
                        </div>
                        <div className="item-desc">
                            <p className="bold color-primary">Unmatched Expertise</p>
                            <p> Built on 40+ years of industry experience, ChemPlan combines deep domain knowledge
                                with technology to deliver actionable insights.
                            </p>
                            <p>Designed by chemical engineers and industry experts, it addresses the unique
                                challenges of the Chemical Process Industries.</p>
                        </div>
                    </div>
                    <div className="item">
                        <div className="item-image">
                            <BlurPublicImage src="/img/svg/menu/Comprehensive Data Coverage.svg"
                                             alt=" Comprehensive Data Coverage" width={230} height={120}/>

                        </div>
                        <div className="item-desc">
                            <p className="bold color-primary">Comprehensive Data Coverage</p>

                            <p> Access global data on 5,000+ producers, 9,000+ plants, 8,000+ processes, and 3,500+
                                products.
                            </p>
                            <p>Stay ahead with weekly updates for plant and process data, and annual updates for
                                market trends.
                            </p>
                        </div>
                    </div>

                    <div className="item">
                        <div className="item-image"><img src="/img/products/Decision-Making.png" alt="Decision-Making"/>
                        </div>
                        <div className="item-desc">
                            <p className="bold color-primary">Advanced Decision-Making Tools</p>
                            <p> Leverage 300+ built-in expert models for “What if?” scenarios, cost analyses, and
                                market forecasts.
                            </p>

                            <p>Generate real-time, customizable reports in PDF or Excel formats for seamless
                                integration into your workflows.
                            </p>
                        </div>
                    </div>
                    <div className="item">
                        <div className="item-image"><img src="/img/products/Tailored Solutions.png"
                                                         alt="Tailored Solutions for Every Need"/></div>
                        <div className="item-desc">
                            <p className="bold color-primary">Tailored Solutions for Every Need</p>

                            <p> ChemPlan Workspace as a SaaS solution for on-demand access, unlimited data and
                                advanced modeling capabilities.
                            </p>
                            <p>Whether you’re a strategic planner, process engineer, or market analyst, ChemPlan
                                Workspace adapts to your needs.
                            </p>
                        </div>
                    </div>


                    <div className="item">
                        <div className="item-image"><img src="/img/products/trusted by industry.png"
                                                         alt="Trusted by Industry Giants"/></div>
                        <div className="item-desc">
                            <p className="bold color-primary">Trusted by Industry Giants</p>

                            <p> ChemPlan is used by global leaders like BASF, Dow Chemical, ExxonMobil, and Shell to
                                make smarter, faster, and more confident decisions.
                            </p>
                            <p> Join a network of industry pioneers who rely on ChemPlan to stay competitive and
                                innovative.
                            </p>
                        </div>
                    </div>

                    <div className="item">
                        <div className="item-image"><img src="/img/products/driving innovaition.png"
                                                         alt="Driving Innovation and Efficiency"/></div>
                        <div className="item-desc">
                            <p className="bold color-primary">Driving Innovation and Efficiency</p>
                            <p> From cost optimization and process improvement to market entry strategies, ChemPlan
                                Workspace empowers you to tackle complex challenges with ease.
                            </p>
                            <p> Transform raw data into strategic opportunities and drive growth in a rapidly
                                evolving industry.
                            </p>
                        </div>
                    </div>

                </div>

                <p style={{marginBottom: "25px",marginTop: "25px"}}>Leaders across the industry trust TranTech Consultants because we
                    convert data into clear, actionable strategies that drive sustainable growth—from enhancing
                    production efficiencies to fostering long-term market resilience. Our commitment to excellence and
                    relentless innovation positions us as a partner of choice for organizations that aspire to lead the
                    future of the chemical and process sectors.</p>
                <div>

                    <div className="container talk-to-an-expert">
                        <div>
                            <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200}
                                             height={100}/>

                        </div>
                        <div>
                            <h3 className="color-primary">Talk to an expert</h3>
                            <br/>
                            <p className="bold">
                                Strategic guidance tailored to your business</p>
                            <br/>
                            <p>Unlock the full potential of your operations with insights directly from our team of experts. At TranTech Consultants, we understand that every business faces unique challenges—our seasoned professionals are ready to provide the tailored strategies you need to drive sustainable growth and operational excellence.
<br/>
<br/>
                                Contact us today to arrange your consultation. Let our industry leaders show you how partnering with TranTech can transform your business and secure your competitive edge in the global market.
                            </p>
                            <br/>

                            <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i>
                            </button>
                            <br/>
                            <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i>
                            </button>


                        </div>
                    </div>


                </div>
            </div>


        </div>


    </div>)
}


export default Page;