import {BlurPublicImage} from "@/app/components/BlurImage";
import {generateMetadata} from "@/app/helpers/generateMetadata";
export const metadata = generateMetadata({
    title: "Leader in Chemical Process Technology",
    description: "Our team pioneers chemical, petrochemical & polymer process planning, investment & engineering. Mitigate risks & optimize CAPEX for success.",
    keywords: "integrated process optimization, petrochemical investment modeling, experienced process experts, techno-economic engineering, strategic guidance"
})

const About = () => {

    return (
        <div className="container-fluid">
            <div className=" page-content">

                <div className="page-title">
                    <div className="container">
                        <h2>About TranTech</h2>

                        <p className="color-secondary">Our story, decades of chemical industry expertise</p>
                        <p style={{fontSize: "1rem"}}>From our founding vision to today's market-leading solutions; four
                            decades of trusted advisory services for the chemical sector</p>
                        <br/>
                    </div>
                </div>
            </div>
            <div id="company" className=" content">

                <div className="inner-content container">
                    <div className="row">
                        <div className="col-6 story-content">

                            <p>
                                At TranTech Consultants, we believe that deep technical expertise and innovative
                                analytics are the cornerstones of success in today’s complex chemical and process
                                industries. For over 40 years, TranTech Consultants, Inc. has been a trusted leader in
                                the Chemical Process Industries (CPI), delivering innovative solutions and unparalleled
                                expertise to clients worldwide. Founded in 1981, TranTech was established to provide an
                                innovative approach to strategic decision-making for the CPI. As a privately held
                                corporation based in Pennsylvania, we have built our reputation on a foundation of
                                excellence, integrity, and a commitment to empowering our clients with the tools and
                                insights they need to succeed.
                                <br/>
                                <br/>
                                Our story is one of relentless innovation and dedication. Founded by industry experts
                                committed to excellence, TranTech Consultants has grown into a global leader—monitoring
                                over 9,000 plants and analyzing 8,000 critical processes across 5,000 production sites
                                worldwide. We have continually evolved our methodologies to address shifting market
                                dynamics, stricter regulatory demands, and emerging sustainability challenges. Guided by
                                experience and fueled by technological advances, our team transforms complex challenges
                                into clear, strategic opportunities.
                            </p>

                            <div className="blue-box">
                                <p> At TranTech, we believe that</p>
                                <p style={{fontSize: "2.09rem"}} className="bold color-primary">TURST</p>
                                is earned through
                                <p><span className="bold color-primary">excellence, integrity</span>, and <span
                                    className="bold color-primary">commitment.</span></p>
                            </div>
                            <p>We pride ourselves on being more than a consulting firm. We are a dedicated partner to
                                our clients, offering a comprehensive suite of services spanning engineering and design,
                                strategic planning, market intelligence, and sustainability solutions. Our integrated
                                approach draws on decades of practical knowledge and sophisticated analytics to
                                customize strategies that are perfectly aligned with each client’s operational needs and
                                long-term objectives. Whether streamlining production processes or leveraging digital
                                insights for market advantage, we ensure that every solution is tailored, efficient, and
                                future-proof.</p>
                        </div>
                        <div className="col-4 story-image">
                            <BlurPublicImage style={{position: "absolute", width: "40%", height: "auto"}}
                                             src={"/img/about/Stone balancing for trust.webp"}
                                             alt={"Stone balancing for trust"} width={2672} height={2610}/></div>
                    </div>

                    <div className="column company-philosophy company-philosophy-about">
                        <div className="row">
                            <div className="col-5 our">
                                <h3>our Mission</h3>
                                <p>To provide data-driven solutions and expert insights that empower businesses in the
                                    Chemical Process Industries to make smarter, faster, and more confident decisions.
                                </p>
                            </div>
                            <div className="col-5 our">
                                <h3>our Vision</h3>
                                <p>To be the global leader in chemical industry intelligence, transforming the way
                                    businesses operate through innovation, expertise, and trust.</p>
                            </div>
                        </div>
                        <div>
                            <div className="our">
                                <h3>our Values</h3>
                                <p><span className="bold">Excellence:</span> We strive for the highest
                                    standards in everything we do.</p>
                                <p><span className="bold">Integrity:</span> We build trust through
                                    transparency and honesty.</p>
                                <p><span className="bold">Innovation:</span> We embrace change and drive
                                    progress through technology.</p>
                                <p><span className="bold">Collaboration:</span> We work together with our
                                    clients and partners to achieve success.</p>
                                <p><span className="bold">Sustainability:</span> We are committed to creating
                                    solutions that support a sustainable future.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="company" className=" content">

                <div className="our-team">
                    <div className="inner-content container">
                        <p>
                            At the heart of our mission is a commitment to sustainability and innovation. As industries
                            worldwide shift towards greener practices, we are at the forefront, helping businesses
                            reduce their environmental footprint while maximizing economic performance. We continuously
                            invest in research, technology, and professional development to remain agile and responsive
                            in a rapidly changing global landscape.
                            <br/>
                            <br/>
                            Integrity, excellence, and a forward-thinking mindset are the values that define TranTech
                            Consultants. We believe that by combining rigorous technical expertise with creative
                            problem-solving, we can help our clients turn challenges into strategic advantages. Our
                            global perspective and diverse capabilities make us a trusted advisor to some of the world’s
                            leading chemical and process companies, and we are proud to continually deliver solutions
                            that drive sustainable, impactful results.
                        </p>

                    </div>
                </div>
            </div>

            <div id="board-leadership-team" className="page-content">

                <div className="page-title">
                    <div className="container">
                        <h2>Board and leadership team</h2>

                        <p className="color-secondary">Team of passionate professionals behind TranTech</p>
                        <p style={{fontSize: "1rem"}}>From process engineering pioneers to digital
                            transformation experts; the minds behind our innovative solutions</p>
                        <br/>
                    </div>
                </div>
            </div>
            <div id="company" className="container content">
                <div className="our-team">

                    <div className="leadership">

                        <br/>
                        <br/>
                        <p style={{marginTop: "5px"}}>At TranTech Consultants, our success is driven by a board and
                            leadership team that brings
                            decades of industry expertise, visionary strategic insight, and an unwavering commitment
                            to
                            excellence. Our team is our greatest asset. From chemical engineers and data scientists
                            to
                            industry experts and software developers, we bring together diverse skills and
                            perspectives
                            to deliver exceptional value to our clients. Together, they form the backbone of our
                            organization—guiding our mission, shaping our strategic direction, and ensuring that our
                            cutting-edge solutions consistently meet the demands of a rapidly evolving chemical and
                            process landscape.</p>


                        <br/>
                        <h3>Leadership</h3>
                        <div className="row leader">
                            <div className="col-2" style={{paddingRight: "15px"}}><img
                                src="/img/about/mr-amirnazmi.jpg"
                                alt="leadership"/></div>
                            <div className="col-8 partner">
                                <p className="name">Ali Amirnazmi, PhD</p>
                                <p className="color-secondary">Principal Founder and President</p>
                                <p className="desc">
                                    Ali has a PhD in chemical engineering from Stanford University. He also holds
                                    graduate and undergraduate degrees in Chemical Engineering and Business from
                                    Stanford, University of California at Berkeley, and University of Tehran where
                                    he
                                    was ranked number one. His professional experience comprises over 30 years of
                                    senior
                                    level management and staff positions in industry, including TranTech, Stauffer
                                    Chemical, Stanberk, Bechtel, and Hercules. Since forming TranTech in 1981, his
                                    expertise includes strategic planning, database structure design, chemical
                                    engineering, plant and process design, market research and research and
                                    development.
                                </p>
                            </div>
                        </div>

                        <h3 style={{marginTop: "35px"}}>Principale Experts</h3>
                        <div className="row" style={{gap: "20px"}}>
                            <div className="col-5 partner">
                                <p className="name">Partha Pratim Das</p>
                                <p className="color-secondary">Programmer Analyst</p>
                                <p className="desc">
                                    Partha is a graduate of Indian Institute of Technology Kharagpur. He holds a BSc
                                    degree in computer science with 10 years of experience in database design and
                                    programming.
                                </p>
                            </div>
                            <div className="col-5 partner">
                                <p className="name">John (Chieh-Lang) Huang</p>
                                <p className="color-secondary">Polymers Business Manager</p>
                                <p className="desc">
                                    John holds BSc/MSc degrees in Chemical Engineering from Shanghai University of
                                    Engineering Science and University of California at Berkeley. He has over 20
                                    years
                                    of experience in marketing, sales and product support at Sinopec and several
                                    multinational companies in China.
                                </p>
                            </div>
                        </div>

                        <div className="row" style={{marginTop: "35px", gap: "20px"}}>
                            <div className="col-5 partner">
                                <p className="name">Kamal Nusaev</p>
                                <p className="color-secondary">Intermediate Organic Chemicals Business Manger</p>
                                <p className="desc">
                                    Kamal holds a Master's degree in Organic and Petroleum Chemistry from Buku State
                                    University in Azarbaijan. His experience includes 12 years of R&D, marketing and
                                    planning at Lukoil Overseas BVI Limited and Turkiye Petrolerri A.O.
                                </p>
                            </div>
                            <div className="col-5 partner">
                                <p className="name">Jeffrey F. Holmes</p>
                                <p className="color-secondary">Water Soluble Resins and SAP Business Manager</p>
                                <p className="desc">
                                    Jeffrey holds a Master’s degree in Chemical Engineering from the School of
                                    Chemical
                                    Engineering and Analytical Science at Manchester University. He has over 20
                                    years of
                                    experience working for Ciba Specialty Chemicals in marketing, process
                                    engineering
                                    and business development.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div className="container-fluid page-content">
            <div className="container talk-to-an-expert">
                <div>
                    <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200} height={100}/>

                </div>
                <div>
                    <h3 className="color-primary">Talk to an expert</h3>
                    <br/>
                    <p className="bold">
                        Need strategic guidance for your chemical business?
                    </p>
                    <br/>
                    <p>
                        Connect directly with our seasoned leadership to gain strategic insights and guidance that
                        propel your business forward. Our Leadership Team are not only at the helm of TranTech
                        Consultants—they also serve as industry thought leaders with decades of experience navigating
                        complex market challenges. Whether you’re interested in learning more about our governance
                        philosophy or looking for expert advice on operational excellence and sustainability, our
                        experts are ready to engage with you.
                        <br/><br/>
                        Contact us today to schedule a consultation and discover how our leadership insights can
                        translate into actionable, impactful strategies for your business. Let’s turn visionary ideas
                        into sustainable, strategic success.
                    </p>
                    <br/>

                    <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i></button>
                    <br/>
                    <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i></button>


                </div>
            </div>
            </div>
        </div>

    )
}

export default About