"use client"
import {Swiper, SwiperSlide} from "swiper/react";
import {Autoplay, Navigation, Pagination} from "swiper/modules";
import 'swiper/css';
import 'swiper/css/pagination';
import {clients} from "@/app/data/clients.json"


export const Carousel_Logos = () =>{
    let logos = [...clients].sort(() => Math.random() - 0.5);

    const groupedLogos = [];
    for (let i = 0; i < logos.length; i += 3) {
        groupedLogos.push(logos.slice(i, i + 3));
    }

    return (
        <div className="company-carousel-logo">

            <Swiper
                slidesPerView={1}
                spaceBetween={13}
                speed={3000} // سرعت حرکت اسلاید (هر اسلاید ۳ ثانیه طول میکشه طی بشه)
                autoplay={{
                    delay: 0, // تأخیر صفر یعنی بدون توقف بین اسلایدها
                    disableOnInteraction: false,
                }}
                breakpoints={{
                    640: {
                        slidesPerView: 1,
                        spaceBetween: 20,
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 40,
                    },
                    1024: {
                        slidesPerView: 4,
                        spaceBetween: 50,
                    },
                }}
                centeredSlides={true}
                loop={true}
                modules={[Autoplay, Pagination, Navigation]}
                className="mySwiper"
            >


            {groupedLogos.map((group, groupIndex) => (
                <SwiperSlide>
                <div key={groupIndex} className="logo-group">
                    {group.map((logo, logoIndex) => (
                        <div key={logoIndex} className="logo-item">
                            <img src={logo.img} alt={logo.name}/>

                        </div>
                    ))}
                </div>
                </SwiperSlide>
            ))}

            </Swiper>
        </div>
    );


}