'use client';

import {useState} from 'react';
import axios from "axios";

export default function BooKDemoCallForm({show, setShow}) {
    const [formData, setFormData] = useState({
        firstName: '', lastName: '', message: '', email: '', phone: '', company: '', jobTitle: '', fieldOfActivity: '',
    });

    const [status, setStatus] = useState('');

    const handleChange = (e) => {
        const {name, value, type, checked} = e.target;
        setFormData((prev) => ({
            ...prev, [name]: type === 'checkbox' ? checked : value,
        }));
    };

    const handleSubmit = async (e) => {
        e.preventDefault();
        setStatus('Sending...');
        try{
            const res = await axios.post('/api/email/book-demo-call', formData);

            if (res.status===200) {
                setStatus('Message sent successfully!');
                setFormData({
                    firstName: '',
                    lastName: '',
                    message: '',
                    email: '',
                    phone: '',
                    company: '',
                    jobTitle: '',
                    fieldOfActivity: '',
                    subscribe: false,
                });
            } else {
                setStatus('Failed to send message.');
            }
        }catch (e) {
            setStatus('Failed to send message.');
        }
    };


    return (<>
            {show && <div onClick={()=>setShow(false)} className="overlay-blue overlay-hidden"></div>}
            {show && <div className={`contactForm flowContactForm ${show ? "contactFormShow" : ""} `}>
                <h2 style={{fontSize: "1.5rem"}}>Arrange Your Consultation</h2>
                <button onClick={()=>setShow(false)} className="close"><i className="fa-regular fa-close"></i></button>
                <form onSubmit={handleSubmit}>
                    <input
                        type="text"
                        name="firstName"
                        placeholder="First Name *"
                        value={formData.firstName}
                        onChange={handleChange}
                        required
                    />
                    <input
                        type="text"
                        name="lastName"
                        placeholder="Last Name *"
                        value={formData.lastName}
                        onChange={handleChange}
                        required
                    />
                    <textarea
                        name="message"
                        placeholder="Your Message *"
                        value={formData.message}
                        onChange={handleChange}
                        required
                    />
                    <input
                        type="email"
                        name="email"
                        placeholder="Business Email *"
                        value={formData.email}
                        onChange={handleChange}
                        required
                    />
                    <input
                        type="tel"
                        name="phone"
                        placeholder="Phone Number * (like +1 234 567 8910)"
                        value={formData.phone}
                        onChange={handleChange}
                        required
                    />
                    <input
                        type="text"
                        name="company"
                        placeholder="Company Name*"
                        value={formData.company}
                        onChange={handleChange}
                        required
                    />
                    <input
                        type="text"
                        name="jobTitle"
                        placeholder="Job Title"
                        value={formData.jobTitle}
                        onChange={handleChange}
                    />
                    <input
                        type="text"
                        name="fieldOfActivity"
                        placeholder="Field of Activity"
                        value={formData.fieldOfActivity}
                        onChange={handleChange}
                    />
                    <button type="submit">
                        Schedule the Call <i className="fa-regular fa-arrow-right"></i>
                    </button>
                    {status && <p className={"status"}>{status}</p>}
                </form>
            </div>}

        </>);
}
