export function generateMetadata({ title, description, keywords, index = true, image }) {
    title = title || '';
    description = description || '';
    keywords = keywords || '';

    const robots = (index !== false) ? 'index, follow' : 'noindex, nofollow';

    return {
        title: `${title} | TranTech`,
        description,
        keywords: keywords.split(',').map(k => k.trim()),
        robots,
        openGraph: {
            title: `${title} | TranTech`,
            description,
            images: image ? [image] : [],
        },
        // twitter: {
        //     title: `${title} | TranTech`,
        //     description,
        //     images: image ? [image] : [],
        //     card: 'summary_large_image',
        // },
    };
}
