import {BlurPublicImage} from "@/app/components/BlurImage";
import {generateMetadata} from "@/app/helpers/generateMetadata";

export const metadata = generateMetadata({
    title: "Industry Solutions: Chemical Process Innovations",
    description: "Explore TranTech's industry solutions for chemicals, petrochemicals, polymers, specialities, hydrogen and CO2, energy & utilities, air and waste treatment.",
    keywords: "chemical and petrochemical processes, polymers and resins, speciality chemicals, utilities and energy management, hydrogen economy and decarbonization"
})

const Page = () => {
    return (<div className="container-fluid page-content">
        <div className="page-title">
            <div className="container">
                <h2>Industries</h2>

                <p className="color-secondary">We provide specialized solutions for your sector</p>
                <p style={{fontSize: "1rem"}}>Trusted advisory services spanning chemical and petrochemical sectors to
                    emerging green technologies</p>
                <br/>
            </div>
        </div>

        <div className="container">
            <p style={{margin: "2rem 0"}}>
                The global chemical and petrochemical industries are continuously evolving, influenced by technological
                advancements, regulatory shifts, energy transition, and changing market dynamics. Companies operating
                within
                these sectors must navigate challenges ranging from production efficiency and supply chain resilience to
                sustainability and market positioning. TranTech Consultants leverages decades of expertise and
                AI-enhanced
                industry intelligence to help businesses adapt, innovate, and stay ahead of market trends.<br/>
                Our industry-specific insights span traditional commodity chemicals, high-value specialty products,
                polymers, and intermediates, as well as emerging sustainability solutions designed to minimize
                environmental
                footprints and maximize operational efficiency. By combining engineering precision, market forecasting,
                and
                process optimization, we deliver tailored strategies that drive competitive advantages and long-term
                profitability.
            </p>
        </div>

        <div className="blue-section">
            <div className="container">
                <BlurPublicImage src={"/img/svg/Chemicals and Petrochemicals white.svg"} width={100} height={100}
                                 alt={"Chemicals and Petrochemicals"}/>

                <h3>Chemicals and Petrochemicals</h3>

                <p>The chemicals and petrochemicals sector serves as the foundation for countless industrial
                    applications, driving economies worldwide through large-scale production and supply chain
                    integration. Companies operating in this space must balance cost competitiveness with high-quality
                    production while navigating strict regulatory landscapes and market fluctuations. Our expertise
                    ensures companies can successfully scale production, refine technology strategies, and integrate
                    digital solutions to maximize performance. Below, we explore our solutions in the chemicals and
                    petrochemicals sector in four parts:</p>

                <ul className="square-blue-list">
                    <li>
                        <p>Commodities</p>
                    </li>
                    <li>
                        <p>Intermediates</p>
                    </li>
                    <li>
                        <p>Speciality chemicals</p>
                    </li>
                    <li>
                        <p>Polymers and resins</p>
                    </li>
                </ul>

            </div>
        </div>

        <div className="container">

            <div style={{marginTop: "2rem"}}>
                <p> Developing efficient and scalable chemical processing systems requires a deep understanding of
                    technology integration, operational optimization, and strategic execution. TranTech Consultants
                    delivers comprehensive engineering and design solutions, helping businesses unlock the full
                    potential of their processes by integrating cutting-edge technologies, digital modeling, and
                    precision engineering. Our approach is data-driven and industry-focused, ensuring that every
                    aspect of plant operations—from technology licensing to process operation optimization—aligns
                    with business objectives.
                </p>
                <p>Whether you need technology selection support, existing production line debottlenecking, digital
                    twin implementation, or engineering designs for specialty chemicals, polymers, and
                    intermediates, we provide expert-level engineering services. Our solutions are rooted in decades
                    of industry experience, process fundamentals, economic feasibility, and adaptability to evolving
                    regulations and market dynamics.</p>
            </div>


            <div className="items-list">
                <div id="commodities" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Commodities</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Commodity chemicals are mass-produced, serving as essential raw materials for countless
                            industries. The success of commodity chemical manufacturers depends on their ability to
                            maintain low-cost operations, optimize resource allocation, and ensure consistent product
                            quality. TranTech Consultants provides comprehensive process analyses and cost optimization
                            models to help businesses streamline production while staying resilient in fluctuating
                            markets.
                            Commodity producers focus on achieving economies of scale. Every percentage point
                            improvement in process efficiency or waste minimization can translate into substantial cost
                            savings. Our tailored solutions guide companies on optimizing plant capacities, streamlining
                            raw material procurement, and reducing energy consumption. With a deep understanding of
                            global market dynamics and regulatory compliance, we help commodity chemical producers
                            enhance their competitiveness and maintain consistent product quality even as market
                            conditions shift.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Cost optimization models – </span>
                                <span>Reduce capital and operational expenditures through efficiency-driven methodologies</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Supply chain resilience – </span>
                                <span>Strengthen procurement strategies to minimize disruptions and maintain steady raw material availability</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Market pricing analytics – </span>
                                <span>Monitor global trade flows and dynamic pricing shifts to adjust financial models</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Scalability planning – </span>
                                <span>Design production expansions that accommodate shifting demand without excessive capital investment</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Forecasting & trend analysis – </span>
                                <span>Predict market movements with AI-driven intelligence, mitigating risks from pricing volatility and economic downturns</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="intermediates" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Intermediates</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Intermediate chemicals serve as the critical building blocks to produce finished products
                            and their production must balance process efficiency, quality assurance, and supply chain
                            fluidity. Our expertise allows businesses to fine-tune production parameters, enhance
                            material conversion processes, and streamline supply logistics to maintain competitive
                            advantages.
                            Our approach to intermediate production focuses on refining process integration, enhancing
                            quality control mechanisms, and ensuring that every conversion step maximizes yield while
                            preserving purity. We perform detailed risk assessments to identify bottlenecks and
                            vulnerabilities across the value chain and offer solutions that promote a smooth, continuous
                            production flow.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Process integration strategies: </span>
                                <span>Enhance the coordination between stages of raw material conversion and final product production to improve continuity and minimize transition gaps</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Supply chain optimization: </span>
                                <span>Ensure a steady supply of raw materials to support consistent production flow and proactive inventory management</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Dynamic pricing strategies – </span>
                                <span>Adjust financial models based on fluctuating global demand for intermediates</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Technology upgrades for scalability – </span>
                                <span>Improve processing efficiencies while preparing facilities for capacity expansion</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Regulatory & compliance support – </span>
                                <span>Align production techniques with both local and international environmental and safety regulations</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Technology integration for performance gains – </span>
                                <span>Implement Virtual sensor and digital twin technologies to improve scalability and efficiency</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="speciality-chemicals" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Speciality chemicals</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Specialty chemicals require precision-engineered formulations, advanced process
                            technologies, and differentiated market positioning. These high-value products cater to
                            niche applications where performance, quality, and regulatory adherence are critical. Our
                            strategic support enables businesses to optimize production methodologies, expand into
                            emerging markets, and differentiate their offerings in competitive industries.
                            Producing specialty chemicals calls for innovation and a customer-centric approach. Every
                            formulation is a result of rigorous research and development efforts aimed at delivering
                            superior performance, enhanced functionality, and higher margins. Our expertise in
                            R&D-driven innovation helps companies refine their product formulas, integrate cutting-edge
                            process technologies, and expand their market reach.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p><span style={{fontWeight: "bold"}}>R&D-driven innovation – </span>
                                <span>Support research efforts to develop breakthrough formulations that outperform conventional alternatives</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Market differentiation strategies – </span>
                                <span>Identify specialized customer needs and tailor products accordingly</span></p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Application-specific solutions – </span>
                                <span>Optimize formulations for key sectors such as pharmaceuticals, coatings, electronics, agrochemicals, etc.</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Technology integration for performance gains – </span>
                                <span>Implement Virtual sensor and digital twin technologies to improve scalability and efficiency</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Sustainable production methods – </span>
                                <span>Incorporate green chemistry principles to align with regulatory and consumer sustainability expectations</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="polymers-and-resins" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Polymers and resins</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Polymers and resins are essential materials across various industrial applications, from
                            packaging and automotive manufacturing to electronics and medical devices. TranTech
                            Consultants helps businesses optimize production processes, improve polymer characteristics,
                            and integrate sustainability-focused solutions to maintain competitive advantage.
                            Optimizing the production of polymers and resins requires a deep understanding of their
                            molecular behavior and the interplay of various processing parameters. Our solutions in this
                            area focus on improving production techniques, enhancing material properties, and
                            integrating sustainable practices. We analyze every stage of the production process—from raw
                            material selection to final product formulation—to ensure that manufacturers can achieve the
                            precise performance characteristics required by end-users. Additionally, we emphasize the
                            importance of recycling and the use of bio-based materials as part of a broader strategy to
                            support circular economy initiatives.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Advanced processing techniques – </span>
                                <span>Utilize innovative manufacturing technologies to improve polymer quality and consistency</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Application-specific solutions – </span>
                                <span>Tailor formulations to meet the unique requirements of diverse applications—ranging from superabsorbent polymers and polyurethanes to degradable polymers, advanced coatings, adhesives, and high-performance thermoplastics and thermosetting resins– ensuring optimal performance, durability, and compliance with industry standards</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Scalability strategies – </span>
                                <span>Expand production capabilities to meet evolving consumer and industrial demands efficiently</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Circular economy solutions – </span>
                                <span>Incorporate bio-based and recycled polymer materials to reduce waste and enhance sustainability</span>
                            </p>
                        </li>
                        <li>
                            <p><span
                                style={{fontWeight: "bold"}}>Regulatory compliance and certification support – </span>
                                <span>Ensure adherence to environmental regulations governing polymer production</span>
                            </p>
                        </li>
                        <li>
                            <p><span style={{fontWeight: "bold"}}>Supply chain efficiency planning – </span>
                                <span>Develop resilient logistics systems to maintain uninterrupted material flow</span>
                            </p>
                        </li>
                    </ul>
                </div>

            </div>


        </div>

        <div className="blue-section" style={{marginTop: "6rem"}}>
            <div className="container" style={{marginTop: "-89px"}}>
                <BlurPublicImage src={"/img/svg/Sustainability solutions white.svg"} width={130} height={130}
                                 alt={"Sustainability solutions"}/>

                <h3>Sustainability solutions</h3>

                <p>The chemical and process industries are undergoing a fundamental shift toward sustainability, driven
                    by tightening regulations, market pressure, and increasing environmental awareness. Companies must
                    now rethink their operations, reduce their ecological footprint, and integrate cleaner
                    technologies—all without compromising efficiency or profitability. TranTech Consultants provides
                    strategic sustainability solutions that combine data-backed insights with cutting-edge engineering
                    to create environmentally responsible, economically viable pathways for the future.<br/>
                    Below, we detail our comprehensive sustainability solutions in five key areas:
                </p>

                <ul className="square-blue-list">
                    <li>
                        <p>Air and waste treatment</p>
                    </li>
                    <li>
                        <p>Waste-to-product strategies </p>
                    </li>
                    <li>
                        <p>Decarbonization roadmaps</p>
                    </li>
                    <li>
                        <p>Hydrogen economy integration</p>
                    </li>
                    <li>
                        <p>Utilities and energy management</p>
                    </li>
                </ul>

                <p>Through these solutions, we empower businesses to minimize emissions, optimize resource utilization,
                    and seamlessly transition toward greener production models while maintaining competitive
                    agility.</p>

            </div>
        </div>

        <div className="container">
            <div className="items-list ">
                <div id="air-and-waste-treatment" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Air and Waste Treatment</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Reducing environmental impact while maintaining operational efficiency requires highly
                            optimized
                            air treatment and waste management systems. Industrial emissions contribute significantly to
                            air
                            pollution, while chemical waste streams pose complex disposal challenges. TranTech
                            Consultants
                            addresses both concerns by integrating advanced filtration, recycling, and conversion
                            technologies into production processes. Our solutions ensure compliance with international
                            environmental standards while optimizing cost-effective waste reduction. Whether
                            implementing
                            industrial gas purification, wastewater treatment, or hazardous waste repurposing, we
                            deliver
                            tailored strategies that maximize environmental benefits and profitability.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Emissions control optimization – </span>
                                <span>Identify and implement state-of-the-art filtration systems, carbon capture, and chemical absorption technologies to reduce atmospheric pollution</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Waste stream analysis & segregation – </span>
                                <span>Conduct comprehensive audits to uncover opportunities for material recovery, reuse, and recycling, minimizing disposal costs</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Industrial wastewater treatment – </span>
                                <span>Utilize biochemical, membrane filtration, and advanced oxidation methods for high-efficiency contaminant removal</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Closed-loop recycling integration – </span>
                                <span>Design zero-waste systems converting manufacturing by-products into reusable feedstock, lowering environmental burdens</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="Wwaste-to-product-strategies" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Waste-to-Product Strategies</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Traditional waste disposal methods incur significant environmental and financial costs.
                            Instead
                            of treating waste as a liability, businesses can convert by-products into marketable assets
                            through circular economy approaches. TranTech Consultants repurposes industrial residues
                            into
                            secondary raw materials, alternative fuels, and recyclable commodities to reduce landfill
                            dependency and create new revenue streams. Our services include material composition
                            analysis,
                            industrial feasibility evaluation, and economic viability assessments to engineer waste
                            conversion aligned with market demand, sustainability goals, and profitability.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Innovative recycling technologies – </span>
                                <span>Apply chemical refining, thermal transformation, and bio-processing to recover usable materials from waste</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Industrial symbiosis models – </span>
                                <span>Establish cross-sector material exchanges, using by-products from one industry as raw inputs for another, leveraging our comprehensive chemical process database</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Economic feasibility studies – </span>
                                <span>Analyze cost-saving opportunities and revenue potential of waste repurposing versus conventional disposal</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Advanced recovery & extraction systems – </span>
                                <span>Develop high-efficiency separation processes for metals, polymers, and specialty chemicals recovery</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Market positioning for recycled materials – </span>
                                <span>Identify high-value applications and branding strategies for repurposed compounds</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="decarbonization-roadmaps" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Decarbonization Roadmaps</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Carbon footprint reduction is essential amid tightening regulations and sustainability
                            mandates
                            worldwide. TranTech Consultants crafts customized decarbonization roadmaps that integrate
                            process redesign, energy optimization, and carbon offset mechanisms to meet emission-cutting
                            targets while maintaining operational excellence. Our expertise ensures transitions to
                            low-carbon feedstocks, renewable energy integration, and process electrification are
                            cost-efficient, technically viable, and future-proof.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Emission reduction planning – </span>
                                <span>Develop CO₂ mitigation strategies including process efficiency improvements and alternative fuel adoption</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Carbon capture & utilization – </span>
                                <span>Deploy advanced absorption, mineralization, and direct air capture technologies to extract and repurpose CO₂</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Energy transition optimization – </span>
                                <span>Integrate renewable energy, storage, and hybrid fuel technologies into chemical production</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Regulatory adaptation frameworks – </span>
                                <span>Align operations with evolving carbon trading markets, EU sustainability mandates, and corporate ESG standards</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="hydrogen-economy-integration" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Hydrogen Economy Integration</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Hydrogen offers zero-emission energy and efficient chemical processing, enabling substantial
                            decarbonization for fossil-reliant industries. TranTech Consultants provides strategic
                            hydrogen
                            integration support, evaluating feasibility, adapting infrastructure, and implementing
                            scalable
                            hydrogen solutions for cleaner production.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Feasibility assessments – </span>
                                <span>Conduct concept studies assessing technical and financial viability tailored to chemical process needs</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Energy transition and process compatibility – </span>
                                <span>Develop roadmaps for shifting from hydrocarbon feedstocks to hydrogen-compatible processes</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Infrastructure development – </span>
                                <span>Design safe hydrogen storage, transport, and distribution networks</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Hydrogen production pathways – </span>
                                <span>Compare blue, green, and grey hydrogen technologies to select optimal integration models</span>
                            </p>
                        </li>
                    </ul>
                </div>

                <div id="utilities-and-energy-management" className="item">
                    <div className="title">
                        <div className="title-icon"></div>
                        <div className="title-text">
                            <h3>Utilities and Energy Management</h3>
                        </div>
                    </div>
                    <div className="desc">
                        <p>
                            Rising energy costs, carbon taxes, and global efficiency standards drive industries to
                            smarter
                            utility and energy management. TranTech Consultants helps optimize resource use through
                            real-time monitoring, process electrification, and renewable integration, reducing costs,
                            emissions, and enhancing sustainability.
                        </p>
                    </div>
                    <ul className="square-blue-list">
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Energy consumption analysis – </span>
                                <span>Identify inefficiencies in steam, cooling, electrical, and fuel usage across processes</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Utility optimization frameworks – </span>
                                <span>Enhance efficiency of process heating, refrigeration, and compressed air systems</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Renewable energy integration – </span>
                                <span>Incorporate solar, wind, and bioenergy sources into industrial power networks, balancing challenges and benefits</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Cost-saving strategies – </span>
                                <span>Implement demand-side management and process optimization to reduce utility expenses</span>
                            </p>
                        </li>
                    </ul>
                </div>

            </div>

        </div>

        <div className="blue-section">
            <div className="container">
                <h2>Why choose TranTech consultants?</h2>
                <p className="color-secondary">Industry-leading expertise backed by data-driven intelligence</p>
                <p>
                    Navigating the complexities of the chemical, petrochemical, and sustainability sectors requires more
                    than conventional consulting—it demands precision, market foresight, and deep technical expertise.
                    TranTech Consultants integrates 40+ years of industry leadership with cutting-edge AI-driven
                    analytics, ensuring that every decision is data-backed, strategic, and commercially optimized.
                    Whether refining product portfolios, optimizing process technologies, or integrating sustainability
                    solutions, we provide tailored guidance that enhances efficiency, minimizes risk, and maximizes
                    profitability.
                </p>
            </div>
        </div>
        <div className="light-blue-section">
            <div className="container">
                <ul className="square-blue-list" style={{marginBottom: "1rem"}}>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Advanced industry intelligence – </span>
                                <span>Leverage real-time insights into 9,000+ plants, 8,000+ processes, and 5,000+ producers worldwide</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Strategic growth frameworks – </span>
                                <span>Implement market segmentation, competitive benchmarking, and investment risk analysis to strengthen market positioning</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Tailored process and market solutions – </span>
                                <span>Align engineering, business, and sustainability initiatives for seamless integration and high-performance outcomes</span>
                            </p>
                        </li>
                        <li>
                            <p>
                                <span style={{fontWeight: "bold"}}>Trusted by industry leaders – </span>
                                <span>Partner with top global manufacturers who rely on TranTech’s insights to drive strategic success</span>
                            </p>
                        </li>

                </ul>

                <p className="color-primary bold" style={{fontSize: "1.2rem"}}>We deliver fully integrated business strategies that secure profitability, efficiency, and sustainability in an evolving market landscape</p>


            </div>
        </div>


        <div className="container talk-to-an-expert">
            <div>
                <BlurPublicImage src={"/img/svg/Talk.svg"} alt={"Talk to an expert"} width={200} height={100}/>

            </div>
            <div>
                <h3 className="color-primary">Talk to an expert</h3>
                <br/>
                <p className="bold">
                    Strategic guidance tailored to your business</p>
                <br/>
                <p>
                    Understanding complex market dynamics, process optimization strategies, and sustainability frameworks requires expert-driven insights—not guesswork. TranTech Consultants enables businesses to make precision-backed strategic decisions, ensuring market opportunities align with process capabilities and long-term business goals.
<br/>
<br/>
                    Whether identifying ideal market segments, evaluating least capital-intensive process technologies, or optimizing production-to-market alignment, our specialists provide customized intelligence designed for your industry niche. We collaborate closely with clients to refine competitive positioning, risk-return analysis, and strategic growth plans, ensuring every decision translates into measurable success.
<br/>
<br/>
                    Contact us today to schedule a consultation, request a customized industry report, or discuss tailored strategies that elevate your business. Let’s turn insights into execution-ready solutions that unlock new growth opportunities and long-term profitability.
                </p>
                <br/>

                <button className="btn-blue">Book a demo call<i className="fa-regular fa-arrow-right"></i></button>
                <br/>
                <button className="btn-blue">Contact us<i className="fa-regular fa-arrow-right"></i></button>


            </div>
        </div>

    </div>)
}


export default Page;