import {SendMail} from "@/server/utils/mailer";


const handler = async (req, res) => {

    if (req.method !== 'POST') {
        return res.status(405).json({
            success: false,
            message: 'Method not allowed',
        });
    }

    const {  firstName, lastName, message, email, phone, company, jobTitle, fieldOfActivity} = req.body;

    const emailContent = `
  <div style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">
    <h2>New Message via Stay Connected</h2>
    <table style="width: 100%; border-collapse: collapse;">
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">First Name</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${firstName || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Last Name</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${lastName || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Email</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${email || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Phone Number</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${phone || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Company</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${company || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Job Title</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${jobTitle || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Field of Activity</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${fieldOfActivity || ""}</td>
      </tr>
      <tr>
        <td style="font-weight: bold; width: 130px; padding: 8px; border: 1px solid #ccc;">Message</td>
        <td style="padding: 8px; border: 1px solid #ccc;">${message || ""}</td>
      </tr>
    </table>
  </div>
`;


    let sendEmail = await SendMail({
        from: "no-replay@viraws.ir",
        to: "miladvgeneral@gmail.com",
        subject: "New Message via Stay Connected | ChemPlan",
        text: emailContent
    })

    return res.status(200).json({sendEmail})
}

export default handler